# Fix macOS app quarantine issue
# Run this after extracting the ZIP file

$AppPath = "$env:USERPROFILE\Downloads\MiBa Video Manager-darwin-arm64\MiBa Video Manager.app"

if (Test-Path $AppPath) {
    Write-Host "Removing quarantine attribute from app..."
    # This would need to run on Mac, not Windows
    # Use this command in Terminal on your Mac:
    # xattr -cr "/path/to/MiBa Video Manager.app"
    
    Write-Host "On your Mac, run this in Terminal:"
    Write-Host "xattr -cr `"$AppPath`""
} else {
    Write-Host "App not found at: $AppPath"
    Write-Host "Please provide the path to the extracted .app folder"
}
